/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.item;

import javax.annotation.Nullable;
import net.creeperhost.chickens.data.ChickenStats;
import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.creeperhost.chickens.handler.IColorSource;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemSpawnEgg
extends Item
implements IColorSource {
    public ItemSpawnEgg(Item.Properties properties) {
        super(properties);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                ItemStack itemstack = new ItemStack((ItemLike)this, 1);
                ItemSpawnEgg.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
                subItems.add((Object)itemstack);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        ChickensRegistryItem chickenDescription = ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(stack));
        if (chickenDescription == null) {
            return new TextComponent("nul1");
        }
        return new TranslatableComponent("entity.chickens." + chickenDescription.getEntityName());
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        ChickensRegistryItem chickenDescription = ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(stack));
        if (chickenDescription == null) {
            return 0;
        }
        return renderPass == 0 ? chickenDescription.getBgColor() : chickenDescription.getFgColor();
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        if (!level.f_46443_) {
            InteractionHand hand = useOnContext.m_43724_();
            ItemStack stack = useOnContext.m_43723_().m_21120_(hand);
            BlockPos blockPos = ItemSpawnEgg.correctPosition(useOnContext.m_8083_(), useOnContext.m_43719_());
            ItemSpawnEgg.activate(stack, level, blockPos);
            if (!useOnContext.m_43723_().m_7500_()) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.PASS;
    }

    public static BlockPos correctPosition(BlockPos pos, Direction side) {
        int[] offsetsXForSide = new int[]{0, 0, 0, 0, -1, 1};
        int[] offsetsYForSide = new int[]{-1, 1, 0, 0, 0, 0};
        int[] offsetsZForSide = new int[]{0, 0, -1, 1, 0, 0};
        int posX = pos.m_123341_() + offsetsXForSide[side.ordinal()];
        int posY = pos.m_123342_() + offsetsYForSide[side.ordinal()];
        int posZ = pos.m_123343_() + offsetsZForSide[side.ordinal()];
        return new BlockPos(posX, posY, posZ);
    }

    public static void activate(ItemStack stack, Level worldIn, BlockPos pos) {
        ResourceLocation entityName = ResourceLocation.m_135820_((String)ItemSpawnEgg.getTypeFromStack(stack));
        EntityChickensChicken entity = (EntityChickensChicken)((EntityType)Registry.f_122826_.m_7745_(entityName)).m_20615_(worldIn);
        if (entity != null && stack.m_41783_() != null) {
            if (stack.m_41783_().m_128441_("baby")) {
                entity.m_6863_(stack.m_41783_().m_128471_("baby"));
            }
            if (stack.m_41783_().m_128441_("love")) {
                entity.m_27601_(stack.m_41783_().m_128451_("love"));
            }
        }
        ChickenStats chickenStats = new ChickenStats(stack);
        if (entity == null) {
            return;
        }
        entity.setStatsAnalyzed(true);
        entity.setGain(chickenStats.getGain());
        entity.setStrength(chickenStats.getStrength());
        entity.setGrowth(chickenStats.getGrowth());
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        entity.setChickenType(ItemSpawnEgg.getTypeFromStack(stack));
        worldIn.m_7967_((Entity)entity);
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation entityId) {
        CompoundTag nbttagcompound = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        CompoundTag nbttagcompound1 = new CompoundTag();
        nbttagcompound1.m_128359_("id", entityId.toString());
        nbttagcompound.m_128365_("ChickenType", (Tag)nbttagcompound1);
        stack.m_41751_(nbttagcompound);
    }

    @Nullable
    public static String getTypeFromStack(ItemStack stack) {
        CompoundTag nbttagcompound = stack.m_41783_();
        if (nbttagcompound != null && nbttagcompound.m_128425_("ChickenType", 10)) {
            new CompoundTag();
            CompoundTag chickentag = nbttagcompound.m_128469_("ChickenType");
            return chickentag.m_128461_("id");
        }
        return null;
    }
}

